# Ya Ticky - PHP Version

This is a simplified PHP-based version of the Ya Ticky project, featuring an automated installer, admin panel, and simplified email/password registration.

## Features

- **Automated Installer**: Visit `/install` to configure your database and set up the initial admin account.
- **Simplified Auth**: Registration and Login use only Email and Password.
- **Admin Panel**: Accessible at `/admin` for users with the 'admin' role.
- **User Dashboard**: Accessible at `/` for registered users.
- **Database Schema**: Pre-defined SQL schema for users, tasks, transactions, and more.

## Setup Instructions

1.  **Environment**: Ensure you have a PHP environment (PHP 8.0+) and MySQL/MariaDB.
2.  **Web Server**: Point your web server's document root to the `public/` directory.
3.  **Installation**:
    - Open your browser and navigate to `http://your-domain/install`.
    - Follow the steps to configure your database.
    - Create your admin account.
4.  **Usage**:
    - After installation, you can login as admin or register as a new user.

## Project Structure

- `app/`: Contains application logic (Controllers, Models, Views).
- `config/`: Configuration files.
- `public/`: Publicly accessible files (index.php, assets).
- `database/`: SQL schema files.
- `.env`: Environment variables (generated by installer).
